﻿<%@ Page Language="c#" CodePage="1200" %>

<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>

<%@ Import Namespace="Soneta.Waluty" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Kasa" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.Kasa.Forms" %>
<%@ Import Namespace="Soneta.Ksiega" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
	<title>Lista dokumentow nierozliczonych - razem</title>
	<script runat="server">

		public enum Zakres
		{
			Razem, Kontrahenci, Pracownicy, Urzędy
		}

		
		public class PrnParams : Soneta.Business.ActualContext
		{
			private Zakres zakres = Zakres.Kontrahenci;
			private IPodmiotKasowy dok;
			private IPodmiotKasowy odk;
			private RodzajDokumentów rodzaj = RodzajDokumentów.Razem;
			private Waluta waluta;
			private String konto = String.Empty;

			
			public PrnParams(Context context)
				: base(context)
			{
				this.waluta = WalutyModule.GetInstance(this).Waluty.PLN;
			}

			
			[Caption("Stan na dzień")]
			[Priority(1)]
			public override Date Aktualny
			{
				set { base.Aktualny = value; }
				get { return base.Aktualny; }
			}

			[Priority(2)]
			public Zakres Zakres
			{
				get { return zakres; }
				set
				{
					zakres = value;
					OnChanged(EventArgs.Empty);
				}
			}

			public RowCondition Condition()
			{
				switch (zakres)
				{
					case Zakres.Kontrahenci:
						return new FieldCondition.TypeOf("Podmiot", typeof(Soneta.CRM.Kontrahent));
					case Zakres.Pracownicy:
						return new FieldCondition.TypeOf("Podmiot", typeof(Soneta.Kadry.Pracownik));
					case Zakres.Urzędy:
						RowCondition condition = RowCondition.Empty;
						condition = new FieldCondition.TypeOf("Podmiot", typeof(Soneta.CRM.Kontrahent));
						condition |= new FieldCondition.TypeOf("Podmiot", typeof(Soneta.Kadry.Pracownik));
						return new RowCondition.Not(condition);
					default:
						return RowCondition.Empty;
				}
			}

			[Caption("Od kontrahenta")]
			[Priority(3)]
			public IPodmiotKasowy Od
			{
				get { return odk; }
				set
				{
					odk = value;
					OnChanged(EventArgs.Empty);
				}
			}

			[Priority(4)]
			[Caption("Do kontrahenta")]
			public IPodmiotKasowy Do
			{
				get { return dok; }
				set
				{
					dok = value;
					OnChanged(EventArgs.Empty);
				}
			}

			
			[Priority(5)]
			[Caption("Rodzaj")]
			public RodzajDokumentów Rodzaj
			{
				get { return rodzaj; }
				set
				{
					rodzaj = value;
					OnChanged(EventArgs.Empty);
				}
			}

			[Required]
			[Priority(6)]
			public Waluta Waluta
			{
				get { return waluta; }
				set
				{
					waluta = value;
					OnChanged(EventArgs.Empty);
				}
			}


			[Priority(8)]
			public String Konto
			{
				get { return konto; }
				set
				{
					konto = value.ToUpper();
					OnChanged(EventArgs.Empty);
				}
			}
		}

		
		PrnParams pars = null;
		[Soneta.Business.Context(Required = true)]
		public PrnParams Params
		{
			get { return pars; }
			set { pars = value; }
		}

	    [Context(Required = true)]
	    public WydrukOddzialParams OParams { get; set; }

		
		private struct CustomerSelection
		{
			private String OdKodu;
			private String DoKodu;

			public void Init(IPodmiotKasowy podmiot1, IPodmiotKasowy podmiot2)
			{
				OdKodu = podmiot1 == null ? null : podmiot1.Kod.ToUpper();
				DoKodu = podmiot2 == null ? null : podmiot2.Kod.ToUpper();

				if (OdKodu != null && DoKodu != null && OdKodu.CompareTo(DoKodu) > 0)
				{
					String tmp = OdKodu; OdKodu = DoKodu; DoKodu = tmp;
				}
			}


			public void EnableFilter(Soneta.Business.View view)
			{
				if (OdKodu != null || DoKodu != null)
					view.FilterCondition += new ConditionHandler(filterProc);
			}


			private void filterProc(object sender, ConditionEventArgs args)
			{
				String pCode = ((RozrachunekIdx)args.Row).Podmiot.Kod.ToUpper();
				args.Accepted &= (OdKodu == null || OdKodu.CompareTo(pCode) <= 0) && (DoKodu == null || pCode.CompareTo(DoKodu) <= 0);
			}


			public String GetTitleString()
			{
				if (OdKodu == null && DoKodu == null)
					return String.Empty;
				else if (OdKodu != null && DoKodu == null)
					return "</strong>Od kontrahenta: <strong>" + HttpUtility.HtmlEncode(OdKodu) + "|";
				else if (OdKodu == null && DoKodu != null)
					return "</strong>Do kontrahenta: <strong>" + HttpUtility.HtmlEncode(DoKodu) + "|";
				else
					return "</strong>Od kontrahenta: <strong>" + HttpUtility.HtmlEncode(OdKodu) + "</strong>, do kontrahenta: <strong>" + HttpUtility.HtmlEncode(DoKodu) + "|";
			}
		}
		
		

		private Date aktualny;
		private StanRozliczeniaRozrachunkuWorker worker;
		private CustomerSelection customerSelection;

		private ZapisRozrachunkuIdx workerZapisu = new ZapisRozrachunkuIdx();
		private String[] kontaArr = null;


		class Podmiot
		{
			readonly string kod;
			readonly string nazwa;
			readonly Date aktualny;
			readonly ArrayList rozrachunki = new ArrayList();
			decimal należności;
			decimal zobowiązania;
			public Podmiot(IPodmiotKasowy podmiot, Date aktualny)
			{
				kod = podmiot.Kod;
				nazwa = podmiot.Nazwa;
				this.aktualny = aktualny;
			}

			public void Add(RozrachunekIdx idx, StanRozliczeniaRozrachunkuWorker worker)
			{
				rozrachunki.Add(idx);
				worker.RozrachunekIdx = idx;

				należności += worker.Naleznosc(aktualny).Value;
				zobowiązania += worker.Zobowiazanie(aktualny).Value;
			}

			public string Kod
			{
				get { return HttpUtility.HtmlEncode(kod); }
			}
			public string Title
			{
				get { return HttpUtility.HtmlEncode(kod + ", " + nazwa); }
			}
			public IEnumerable Rozrachunki
			{
				get { return rozrachunki; }
			}
			public IEnumerable Podsumowanie
			{
				get { return new object[] { this }; }
			}
			public string Opis
			{
				get { return "Saldo:"; }
			}
			public decimal SaldoNależności
			{
				get { return System.Math.Max(należności - zobowiązania, 0m); }
			}
			public decimal SaldoZobowiązania
			{
				get { return System.Math.Max(zobowiązania - należności, 0m); }
			}
		}

		class ComparePodmiot : IComparer
		{
			public int Compare(object x, object y)
			{
				IPodmiotKasowy px = (IPodmiotKasowy)x;
				IPodmiotKasowy py = (IPodmiotKasowy)y;
				return px.Kod.CompareTo(py.Kod);
			}
		}

		void OnContextLoad(object sender, EventArgs e)
		{
			aktualny = pars.Aktualny;
			string symbol = pars.Waluta.Symbol.ToUpper();

			customerSelection.Init(pars.Od, pars.Do);

			//
			// -> przygotowanie filtrów kont
			//

			kontaArr = pars.Konto.Trim().Split(new Char[] { ',', ';', '|' }, StringSplitOptions.RemoveEmptyEntries);

			for (int ix = 0; ix < kontaArr.Length; ix++)
				kontaArr[ix] = kontaArr[ix].Trim();
			if (kontaArr.Length == 0 || kontaArr.Length == 1 && kontaArr[0] == String.Empty)
				kontaArr = null;

            ReportHeader1["ODDZIAL"] = OParams.GetTitleItem();
			ReportHeader1["CUST"] = customerSelection.GetTitleString();
			ReportHeader1["KONTO"] = String.IsNullOrEmpty(pars.Konto.Trim()) ? "(wszystkie)" : pars.Konto;
			ReportHeader1["WALUTA"] = symbol;

			if (pars.Rodzaj == RodzajDokumentów.Razem)
				ReportHeader1["RODZAJ"] = "";
			else
				ReportHeader1["RODZAJ"] = "</strong>Rodzaj: <strong>" + pars.Rodzaj + "|";

			if (pars.Zakres == Zakres.Razem)
				ReportHeader1["ZAKRES"] = "";
			else
				ReportHeader1["ZAKRES"] = "</strong>Zakres: <strong>" + pars.Zakres + "|";

				KasaModule kasa = KasaModule.GetInstance(dc);
				RozrachunkiIdx rozrachunki = kasa.RozrachunkiIdx;

				Soneta.Business.View view = rozrachunki.Nierozliczone(null, new FromTo(Date.MinValue, aktualny), aktualny);
				view.Condition &= pars.Condition();
            	view.Condition &= OParams.GetConditionIdx();

				RowCondition condition = kasa.RozrachunkiIdx.ZakresEx(
					pars.Rodzaj != RodzajDokumentów.Zapłaty,
					pars.Rodzaj != RodzajDokumentów.Zapłaty,
					pars.Rodzaj != RodzajDokumentów.Płatności,
					pars.Rodzaj != RodzajDokumentów.Płatności);
				if (condition != RowCondition.Empty)
					view.Condition &= condition;

				customerSelection.EnableFilter(view);
				view.FilterCondition += new ConditionHandler(KontoFilter);

				worker = new StanRozliczeniaRozrachunkuWorker();
				worker.StanRozliczenia = StanRozliczeniaRozrachunku.Nierozliczone;

				Hashtable ht = new Hashtable();
				foreach (RozrachunekIdx idx in view)
					if (idx.Kwota.Symbol == symbol)
					{
						Podmiot p = (Podmiot)ht[idx.Podmiot];
						if (p == null)
						{
							p = new Podmiot(idx.Podmiot, aktualny);
							ht.Add(idx.Podmiot, p);
						}
						p.Add(idx, worker);
					}

				ArrayList lista = new ArrayList(ht.Keys);
				lista.Sort(new ComparePodmiot());
				for (int i = 0; i < lista.Count; i++)
					lista[i] = ht[lista[i]];
				DataRepeater1.DataSource = lista;
		}

		
		void KontoFilter(object sender, ConditionEventArgs args)
		{
			if (kontaArr == null)
				return;
			if (!args.Accepted)
				return;

			RozrachunekIdx idx = (RozrachunekIdx)args.Row;
			workerZapisu.RozrachunekIdx = idx;

			foreach (String k in kontaArr)
				if (k != String.Empty && Regex.IsMatch(workerZapisu.Konto, GetFilterExpression(k), RegexOptions.CultureInvariant | RegexOptions.IgnoreCase))
					return;

			args.Accepted = false;
		}
		
        string GetFilterExpression(string mask)
		{ return '^' + mask.Replace("\\", "\\\\").Replace("?", ".?").Replace("*", ".*").Replace("_", ".?").Replace("%", ".*") + '$'; }
		
		int Zwłoka(RozrachunekIdx idx)
		{
			if (idx.Termin != Date.Empty)
			{
				Date data = Date.Min(idx.DataRozliczenia, aktualny);
				if (idx.Termin < data)
					return data - idx.Termin;
			}
			return 0;
		}

		decimal należności = 0m;
		decimal zobowiązania = 0m;

		void Grid1_BeforeRow(object sender, Soneta.Web.RowEventArgs args)
		{
			RozrachunekIdx idx = (RozrachunekIdx)args.Row;
			worker.RozrachunekIdx = idx;

			decimal n = worker.Naleznosc(aktualny).Value;
			decimal z = worker.Zobowiazanie(aktualny).Value;

			należność.EditValue = n;
			zobowiązanie.EditValue = z;
			kwotaDokumentu.EditValue = worker.Kwota;

			należności += n;
			zobowiązania += z;
		}


		//
		// Zarzadzanie kontekstem
		//


		private WydrukiRozrachunkowSessionProxy sProxy = null;


		private void OnContextLoading(Object sender, EventArgs args)
		{
			sProxy = WydrukiRozrachunkowSessionProxy.GetSingleDbInstance(dc.Context);
			dc.attachContext(sProxy.CloneContext(dc.Context));
		}


		protected override void OnUnload(EventArgs e)
		{
			WydrukiRozrachunkowSessionProxy.SmartDispose(ref sProxy);
			base.OnUnload(e);
		}
		

	</script>
</head>
<body>
	<form id="ListaDokumentowNierozliczonychRazem" method="post" runat="server">
	<ea:DataContext ID="dc" runat="server" OnContextLoad="OnContextLoad" OnContextLoading="OnContextLoading"  />
	<cc1:ReportHeader ID="ReportHeader1" Title="Lista dokumentów nierozliczonych|%ODDZIAL%</strong>Stan na dzień: <strong>{0}|%RODZAJ%%ZAKRES%%CUST%</strong>Waluta: <strong>%WALUTA%</strong>|Konto: <STRONG>%KONTO%" runat="server" DataMember0="Actual" ContextTypeName="Soneta.Business.ActualDate,Soneta.Business"></cc1:ReportHeader>

	<ea:DataRepeater ID="DataRepeater1" runat="server" Width="707px" Height="124px">
		<div style="height:5px">&nbsp;</div>

		<ea:Grid ID="Grid3" runat="server" DataMember="Podsumowanie" ShowHeader="None" AroundBorder="Double">
			<Columns>
				<ea:GridColumn runat="server" Align="Left" DataMember="Title" Format="&lt;b&gt;{0}&lt;/b&gt;" />
			</Columns>
		</ea:Grid>

		<ea:Grid ID="Grid1" runat="server" DataMember="Rozrachunki" OnBeforeRow="Grid1_BeforeRow">
			<Columns>
				<ea:GridColumn runat="server" Width="4" Align="Right" DataMember="#" Caption="Lp." />
				<ea:GridColumn runat="server" Width="20" DataMember="Numer" Caption="Numer dokumentu" NoWrap="True" />
				<ea:GridColumn runat="server" Width="10" DataMember="Data" Caption="Data dokumentu" />
				<ea:GridColumn runat="server" Width="10" DataMember="Termin" Total="Info" Caption="Termin płatności" />
				<ea:GridColumn runat="server" Align="Right" ID="kwotaDokumentu" Total="Sum" Caption="Kwota dokumentu" Format="{0:n}" />
				<ea:GridColumn runat="server" Align="Right" Total="Sum" Caption="Kwota nierozliczonych~należności" Format="{0:n}" ID="należność" />
				<ea:GridColumn runat="server" Align="Right" Total="Sum" Caption="Kwota nierozliczonych~zobowiązań" Format="{0:n}" ID="zobowiązanie" />
				<ea:GridColumn runat="server" Width="30" DataMember="Dokument.Opis" Caption="Opis dokumentu" NoWrap="True" EncodeHTML="True" />
			</Columns>
		</ea:Grid>

		<ea:Grid ID="Grid2" runat="server" DataMember="Podsumowanie" ShowHeader="None">
			<Columns>
				<ea:GridColumn runat="server" Width="44" Align="Right" DataMember="Opis" Format="&lt;b&gt;{0}&#160;&#160;&#160;&#160;&lt;/b&gt;" />
				<ea:GridColumn runat="server" Caption="B" />
				<ea:GridColumn runat="server" Align="Right" DataMember="SaldoNależności" HideZero="True" Format="&lt;b&gt;{0:n}&lt;/b&gt;" />
				<ea:GridColumn runat="server" Align="Right" DataMember="SaldoZobowiązania" HideZero="True" Format="&lt;b&gt;{0:n}&lt;/b&gt;" />
				<ea:GridColumn runat="server" Width="30" Caption=" C" />
			</Columns>
		</ea:Grid>
	</ea:DataRepeater>

	<cc1:ReportFooter ID="ReportFooter1" runat="server">
		<Subtitles>
			<cc1:FooterSubtitle runat="server" SubtitleType="Operator" />
			<cc1:FooterSubtitle runat="server" Caption="Sporządził" SubtitleType="Podpis" />
			<cc1:FooterSubtitle runat="server" Caption="Sprawdził" SubtitleType="Podpis" />
			<cc1:FooterSubtitle runat="server" Caption="Zatwierdził" SubtitleType="Podpis" />
		</Subtitles>
	</cc1:ReportFooter>
	</form>
</body>
</html>

